//========= Copyright  1996-2002, Valve LLC, All rights reserved. ============
//
// Purpose: 
//
// $NoKeywords: $
//=============================================================================

// Author: Michael S. Booth (mike@turtlerockstudios.com), 2003
// Author: Matthew D. Campbell (matt@turtlerockstudios.com), 2003

#ifndef GAME_EVENT_H
#define GAME_EVENT_H

//
// NOTE: This enum is used by both the client and server, so only add events to the
// end of the list to remain maximally compatible with existing clients.
//

// Define some event types used in various places (CZ bot code, career mode, and tutor, initially)
enum GameEventType
{
	EVENT_INVALID = 0,

	EVENT_WEAPON_FIRED,
	EVENT_WEAPON_FIRED_ON_EMPTY,
	EVENT_WEAPON_RELOADED,
	EVENT_HE_GRENADE_EXPLODED,
	EVENT_FLASHBANG_GRENADE_EXPLODED,
	EVENT_SMOKE_GRENADE_EXPLODED,
	EVENT_GRENADE_BOUNCED,
	EVENT_BEING_SHOT_AT, ///< this will only trigger for the local player in single player games.
	EVENT_PLAYER_BLINDED_BY_FLASHBANG,

	EVENT_PLAYER_FOOTSTEP,
	EVENT_PLAYER_JUMPED,
	EVENT_PLAYER_DIED,
	EVENT_PLAYER_LANDED_FROM_HEIGHT,
	EVENT_PLAYER_TOOK_DAMAGE,

	EVENT_HOSTAGE_DAMAGED,
	EVENT_HOSTAGE_KILLED,

	EVENT_DOOR,
	EVENT_BREAK_GLASS,
	EVENT_BREAK_WOOD,
	EVENT_BREAK_METAL,
	EVENT_BREAK_FLESH,
	EVENT_BREAK_CONCRETE,

	EVENT_BOMB_PLANTED,
	EVENT_BOMB_DROPPED,
	EVENT_BOMB_PICKED_UP,
	EVENT_BOMB_BEEP,										///< timer beep when counting down to detonation
	EVENT_BOMB_DEFUSING,
	EVENT_BOMB_DEFUSE_ABORTED,
	EVENT_BOMB_DEFUSED,
	EVENT_BOMB_EXPLODED,

	EVENT_HOSTAGE_USED,
	EVENT_HOSTAGE_RESCUED,
	EVENT_ALL_HOSTAGES_RESCUED,

	EVENT_VIP_ESCAPED,
	EVENT_VIP_ASSASSINATED,

	EVENT_TERRORISTS_WIN,
	EVENT_CTS_WIN,
	EVENT_ROUND_DRAW,
	EVENT_ROUND_WIN,										///< win/loss relative to the client
	EVENT_ROUND_LOSS,										///< win/loss relative to the client
	EVENT_ROUND_START,
	EVENT_PLAYER_SPAWNED,
	EVENT_CLIENT_CORPSE_SPAWNED,
	EVENT_BUY_TIME_START,
	EVENT_PLAYER_LEFT_BUY_ZONE,					///< triggered by tutor system when the local player leaves the buy zone/buy time expires for the first time.
	EVENT_DEATH_CAMERA_START,
	EVENT_KILL_ALL,											///< everybody on one team has been killed
	EVENT_ROUND_TIME,

	// client-relative events for career mode: has the player killed with certain weapons, etc?

	EVENT_DIE,
	EVENT_KILL,												///< someone has been killed
	EVENT_HEADSHOT,											///< subset of EVENT_KILL
	EVENT_KILL_FLASHBANGED,

	// Tutor Buy menu events
	EVENT_TUTOR_BUY_MENU_OPENNED,
	EVENT_TUTOR_AUTOBUY,
	EVENT_PLAYER_BOUGHT_SOMETHING,
	EVENT_TUTOR_NOT_BUYING_ANYTHING,
	EVENT_TUTOR_NEED_TO_BUY_PRIMARY_WEAPON,
	EVENT_TUTOR_NEED_TO_BUY_PRIMARY_AMMO,
	EVENT_TUTOR_NEED_TO_BUY_SECONDARY_AMMO,
	EVENT_TUTOR_NEED_TO_BUY_ARMOR,
	EVENT_TUTOR_NEED_TO_BUY_DEFUSE_KIT,
	EVENT_TUTOR_NEED_TO_BUY_GRENADE,

	EVENT_CAREER_TASK_DONE,

	// radio messages (these must be kept in sync with actual radio) -------------------------------------

	EVENT_START_RADIO_1,							///< radio messages between this and RADIO_2 and part of Radio1()

	EVENT_RADIO_COVER_ME,
	EVENT_RADIO_YOU_TAKE_THE_POINT,
	EVENT_RADIO_HOLD_THIS_POSITION,
	EVENT_RADIO_REGROUP_TEAM,
	EVENT_RADIO_FOLLOW_ME,
	EVENT_RADIO_TAKING_FIRE,

	EVENT_START_RADIO_2,							///< radio messages between this and RADIO_3 are part of Radio2()

	EVENT_RADIO_GO_GO_GO,
	EVENT_RADIO_TEAM_FALL_BACK,
	EVENT_RADIO_STICK_TOGETHER_TEAM,
	EVENT_RADIO_GET_IN_POSITION_AND_WAIT,
	EVENT_RADIO_STORM_THE_FRONT,
	EVENT_RADIO_REPORT_IN_TEAM,

	EVENT_START_RADIO_3,							///< radio messages above this are part of Radio3()

	EVENT_RADIO_AFFIRMATIVE,
	EVENT_RADIO_ENEMY_SPOTTED,
	EVENT_RADIO_NEED_BACKUP,
	EVENT_RADIO_SECTOR_CLEAR,
	EVENT_RADIO_IN_POSITION,
	EVENT_RADIO_REPORTING_IN,
	EVENT_RADIO_GET_OUT_OF_THERE,
	EVENT_RADIO_NEGATIVE,
	EVENT_RADIO_ENEMY_DOWN,

	EVENT_END_RADIO,

	EVENT_NEW_MATCH,								///< sent at the start of a new map/match.
	EVENT_PLAYER_CHANGED_TEAM,						///< sent when a player changes teams.
	EVENT_BULLET_IMPACT,
	EVENT_GAME_COMMENCE,
	EVENT_WEAPON_ZOOMED,

	EVENT_HOSTAGE_CALLED_FOR_HELP,					///< hostage yelled to a CT

	NUM_GAME_EVENTS
};

#ifdef DEFINE_EVENT_NAMES
// NOTE: These must be kept in sync with the GameEventType enum
const char *GameEventName[ NUM_GAME_EVENTS+1 ] =
{
	"EVENT_INVALID",

	"EVENT_WEAPON_FIRED",
	"EVENT_WEAPON_FIRED_ON_EMPTY",
	"EVENT_WEAPON_RELOADED",
	"EVENT_HE_GRENADE_EXPLODED",
	"EVENT_FLASHBANG_GRENADE_EXPLODED",
	"EVENT_SMOKE_GRENADE_EXPLODED",
	"EVENT_GRENADE_BOUNCED",
	"EVENT_BEING_SHOT_AT",
	"EVENT_PLAYER_BLINDED_BY_FLASHBANG",

	"EVENT_PLAYER_FOOTSTEP",
	"EVENT_PLAYER_JUMPED",
	"EVENT_PLAYER_DIED",
	"EVENT_PLAYER_LANDED_FROM_HEIGHT",
	"EVENT_PLAYER_TOOK_DAMAGE",

	"EVENT_HOSTAGE_DAMAGED",
	"EVENT_HOSTAGE_KILLED",

	"EVENT_DOOR",
	"EVENT_BREAK_GLASS",
	"EVENT_BREAK_WOOD",
	"EVENT_BREAK_METAL",
	"EVENT_BREAK_FLESH",
	"EVENT_BREAK_CONCRETE",

	"EVENT_BOMB_PLANTED",
	"EVENT_BOMB_DROPPED",
	"EVENT_BOMB_PICKED_UP",
	"EVENT_BOMB_BEEP",
	"EVENT_BOMB_DEFUSING",
	"EVENT_BOMB_DEFUSE_ABORTED",
	"EVENT_BOMB_DEFUSED",
	"EVENT_BOMB_EXPLODED",

	"EVENT_HOSTAGE_USED",
	"EVENT_HOSTAGE_RESCUED",

	"EVENT_ALL_HOSTAGES_RESCUED",

	"EVENT_VIP_ESCAPED",
	"EVENT_VIP_ASSASSINATED",

	"EVENT_TERRORISTS_WIN",
	"EVENT_CTS_WIN",
	"EVENT_ROUND_DRAW",

	"EVENT_ROUND_WIN",
	"EVENT_ROUND_LOSS",
	"EVENT_ROUND_START",
	"EVENT_PLAYER_SPAWNED",
	"EVENT_CLIENT_CORPSE_SPAWNED",
	"EVENT_BUY_TIME_START",
	"EVENT_PLAYER_LEFT_BUY_ZONE",
	"EVENT_DEATH_CAMERA_START",
	"EVENT_KILL_ALL",
	"EVENT_ROUND_TIME",

	// client-relative events for career mode: has the player killed with certain weapons, etc?

	"EVENT_DIE",
	"EVENT_KILL",
	"EVENT_HEADSHOT",
	"EVENT_KILL_FLASHBANGED",

	// Tutor Buy menu events
	"EVENT_TUTOR_BUY_MENU_OPENNED",
	"EVENT_TUTOR_AUTOBUY",
	"EVENT_PLAYER_BOUGHT_SOMETHING",
	"EVENT_TUTOR_NOT_BUYING_ANYTHING",
	"EVENT_TUTOR_NEED_TO_BUY_PRIMARY_WEAPON",
	"EVENT_TUTOR_NEED_TO_BUY_PRIMARY_AMMO",
	"EVENT_TUTOR_NEED_TO_BUY_SECONDARY_AMMO",
	"EVENT_TUTOR_NEED_TO_BUY_ARMOR",
	"EVENT_TUTOR_NEED_TO_BUY_DEFUSE_KIT",
	"EVENT_TUTOR_NEED_TO_BUY_GRENADE",

	"EVENT_CAREER_TASK_DONE",

	// radio messages (these must be kept in sync with actual radio) -------------------------------------

	"EVENT_START_RADIO_1",

	"EVENT_RADIO_COVER_ME",
	"EVENT_RADIO_YOU_TAKE_THE_POINT",
	"EVENT_RADIO_HOLD_THIS_POSITION",
	"EVENT_RADIO_REGROUP_TEAM",
	"EVENT_RADIO_FOLLOW_ME",
	"EVENT_RADIO_TAKING_FIRE",

	"EVENT_START_RADIO_2",

	"EVENT_RADIO_GO_GO_GO",
	"EVENT_RADIO_TEAM_FALL_BACK",
	"EVENT_RADIO_STICK_TOGETHER_TEAM",
	"EVENT_RADIO_GET_IN_POSITION_AND_WAIT",
	"EVENT_RADIO_STORM_THE_FRONT",
	"EVENT_RADIO_REPORT_IN_TEAM",

	"EVENT_START_RADIO_3",

	"EVENT_RADIO_AFFIRMATIVE",
	"EVENT_RADIO_ENEMY_SPOTTED",
	"EVENT_RADIO_NEED_BACKUP",
	"EVENT_RADIO_SECTOR_CLEAR",
	"EVENT_RADIO_IN_POSITION",
	"EVENT_RADIO_REPORTING_IN",
	"EVENT_RADIO_GET_OUT_OF_THERE",
	"EVENT_RADIO_NEGATIVE",
	"EVENT_RADIO_ENEMY_DOWN",

	"EVENT_END_RADIO",

	"EVENT_NEW_MATCH",
	"EVENT_PLAYER_CHANGED_TEAM",
	"EVENT_BULLET_IMPACT",
	"EVENT_GAME_COMMENCE",
	"EVENT_WEAPON_ZOOMED",

	"EVENT_HOSTAGE_CALLED_FOR_HELP",

	NULL		// must be NULL-terminated
};
#else
extern const char *GameEventName[ NUM_GAME_EVENTS ];
#endif

/// convert name to GameEventType
extern GameEventType NameToGameEvent( const char *name );

#endif // GAME_EVENT_H
